-- phpMyAdmin SQL Dump
-- version 5.2.1
-- https://www.phpmyadmin.net/
--
-- Host: localhost:3306
-- Generation Time: Oct 19, 2025 at 05:34 AM
-- Server version: 8.0.34
-- PHP Version: 8.3.13

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

--
-- Database: `reviewprcom_db`
--

-- --------------------------------------------------------

--
-- Table structure for table `orders`
--

CREATE TABLE `orders` (
  `id` int NOT NULL,
  `order_number` varchar(20) NOT NULL,
  `customer_name` varchar(100) NOT NULL,
  `customer_email` varchar(100) NOT NULL,
  `customer_phone` varchar(20) DEFAULT NULL,
  `product_id` int NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `quantity` int NOT NULL DEFAULT '1',
  `amount` decimal(10,2) NOT NULL,
  `status` enum('pending','processing','completed','cancelled','refunded') NOT NULL DEFAULT 'pending',
  `payment_status` enum('pending','paid','failed','refunded') NOT NULL DEFAULT 'pending',
  `payment_method` varchar(50) DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `notes` text,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_number` (`order_number`),
  KEY `product_id` (`product_id`),
  KEY `customer_email` (`customer_email`),
  KEY `status` (`status`),
  KEY `payment_status` (`payment_status`),
  KEY `idx_orders_status_created` (`status`,`created_at`),
  KEY `idx_orders_customer` (`customer_email`,`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `order_status_history`
--

CREATE TABLE `order_status_history` (
  `id` int NOT NULL AUTO_INCREMENT,
  `order_id` int NOT NULL,
  `old_status` varchar(50) DEFAULT NULL,
  `new_status` varchar(50) NOT NULL,
  `notes` text,
  `changed_by` int DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `changed_by` (`changed_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- --------------------------------------------------------

--
-- Table structure for table `products`
--

CREATE TABLE `products` (
  `id` int NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text,
  `detailed_description` text,
  `price` decimal(10,2) NOT NULL,
  `stock` int NOT NULL DEFAULT '0',
  `image` varchar(255) DEFAULT NULL,
  `category` varchar(100) DEFAULT NULL,
  `position` int DEFAULT '0',
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `products`
--

INSERT INTO `products` (`id`, `name`, `description`, `detailed_description`, `price`, `stock`, `image`, `category`, `position`, `status`, `created_at`, `updated_at`) VALUES
(1, 'G2 Reviews', 'High-quality and Authentic User Post. No IP , No Proxy', 'Experience superior sound quality with our premium wireless headphones. Featuring advanced noise cancellation technology, these headphones deliver crystal-clear audio with deep bass and crisp highs. The ergonomic design ensures comfortable wearing for extended periods, while the long-lasting battery provides up to 30 hours of playback. Perfect for music lovers, commuters, and professionals who demand the best in audio technology. Key features include Bluetooth 5.0 connectivity, quick charge capability, and premium leather padding for ultimate comfort.', 21.99, 250, 'http://reviewpr.com/img/G2.R.jpg', 'Positive Saas Reviews', 1, 'active', '2025-10-06 11:56:36', '2025-10-09 12:43:48'),
(5, 'Sitejabber Reviews', 'The Best Premium-Quality Sitejabber Reviews', '', 3.00, 5000, 'http://reviewpr.com/img/SitejabberRRR.png', 'Positive Saas Reviews', 21, 'active', '2025-10-06 11:56:36', '2025-10-09 12:31:14'),
(17, 'Trustpilot Reviews', '5 Star TrustPilot Reviews  - Genuine and Top Quality ', 'Everyone is trying to save money as one never knows what may happen next. With this in mind, you will want to buy cheap Trustpilot reviews. We have a range of packages at very competitive rates. It doesn\'t matter what your budget is, we will be able to help you! If you want to know how to increase Trustpilot reviews, don\'t hesitate and contact us today. A member of our team of review specialists will contact you so that we can work on a package to meet your business\'s needs before you can blink your eyes! ', 2.10, 5000, 'http://reviewpr.com/img/TrustpilotR.png', 'Positive Saas Reviews', 2, 'active', '2025-10-07 06:01:19', '2025-10-09 12:44:04'),
(18, 'Google Reviews', 'The Great Place to Buy Google Positive Reviews', 'If you want to know the ideal site to obtain Google reviews, you have come to the right place. Our business employs a team of dedicated professionals from many different geographical regions and areas of expertise that will help you to obtain Google reviews.', 3.50, 5000, 'http://reviewpr.com/img/GoogleR.png', 'Positive Saas Reviews', 47, 'active', '2025-10-07 06:57:09', '2025-10-09 12:37:17'),
(19, 'Clutch.co Reviews', 'Buy quality Clutch.co Reviews', 'You can purchase good clutch. co reviews from credible sites such as ReviewPR. There are already more sites selling reviews out there. But not all sites selling reviews are authentic or can provide quality reviews as they promise. If you buy reviews easily from trusted sites, you will be able to find and buy Clutch.co Reviews for cheap and bulk. These are organic reviews that will be added to your clutch profile upon the completion of your purchase.\r\n\r\nWe consider ReviewPR to be one of the best sites to get quality Clutch - B2B ratings and reviews ratings from. They have good customer service that will fix (and are available to fix) any review purchase issues immediately. They also guarantee 100 quality with their reviews - which is something nearly impossible to obtain from other sites!', 19.99, 5000, 'http://reviewpr.com/img/ClutchR.png', 'Positive Saas Reviews', 4, 'active', '2025-10-07 07:03:18', '2025-10-09 12:44:21'),
(20, 'Reviews.io Reviews', 'Best Place to Buy Reviews.io Reviews ', 'In order to help you, we need three things to provide the appropriate agency services to you.\r\n\r\n1. We need to understand your business. When we know your target market, we will understand the type of service required as well as the feedback from potential customers. The ratings and phraseology will be key.\r\n\r\n2. We need you to provide a listing of your company, so we can all dissect what it means to reach your potential customers about your service. It will be less demanding and of little concern for us to gather your reviews on Reviews.Io if we know were all your product listings are, as well as customer listings in the past few months, a year, or so.\r\n\r\n3. Lastly, we need you to trust our system and process. It will not take more than a week or two to improve your conversion rate and get you selling and making your money back. You can always contact customer service for your queries.\r\n\r\nWe know what you need, as we have had them before. We know how to answer them, as we were all there at one time for our business. Take a breath and take each small step, we are here to support and help in every way we can.', 3.99, 5000, 'http://reviewpr.com/img/Reviews.oiR.png', 'Positive Saas Reviews', 20, 'active', '2025-10-07 07:05:51', '2025-10-09 12:45:58'),
(21, 'Airbnb Reviews', 'Buy quality Airbnb Reviews', 'We provide true Airbnb reviews, and we may provide you one or a few positive, negative or sometimes zero reviews. But we charge you solely for the positive. From that, you can infer the credibility and sincerity of our service. We continue to wait for positive reviews, as we have no ability to convince honest users to change their comments online. A customer was at your Airbnb service, and they write the reviews regarding their experience. It doesn\'t come from a fabricated story.', 8.00, 5000, 'http://reviewpr.com/img/AirbanR.png', 'Positive Saas Reviews', 26, 'active', '2025-10-07 07:08:27', '2025-10-09 12:32:15'),
(22, 'Facebook Reviews', 'Buy Facebook Positive Reviews - FAQ ', 'Trust us when we say that your business needs authentic positive Facebook reviews. If you\'re still unsure, we\'ve created a special Question and Answer section to answer some of your questions.', 1.10, 5000, 'http://reviewpr.com/img/FacebookR.png', 'Positive Saas Reviews', 35, 'active', '2025-10-07 07:13:07', '2025-10-09 12:34:00'),
(23, 'Google Play Reviews', 'The Best Online Source of Premium-Quality Android Reviews', 'Locating the most suitable website to buy Android reviews can be overwhelming. However, there is no need for concern because ReviewPR is here to help you best.\r\n\r\nIf you are new to ReviewPR, where you can buy Android application reviews, you will not be disappointed by this wonderful online establishment. It is rank one when searching for high-quality social media accounts, including Twitter, Instagram, or Facebook.\r\n\r\nIn addition, ReviewPR has more products to offer. In addition to buying Android reviews online, this online services provider allows you to purchase an apparent two high-quality products:\r\n\r\n1)  QUALITY GOOGLE PLAY REVIEWS\r\n\r\nThis product offers real Android reviews with authentic users. In addition, the texts are high-quality and relevant and available in English. The Quality Google Play Reviews supplied by ReviewPR provides a five-star rating.\r\n\r\nYou will experience instant delivery, 100-per cent security, and customer service available 24/7. Are you looking to buy cheap Android reviews? The Quality Google Play Reviews is a great option for as little as US $4.99.\r\n\r\n2)  CUSTOM GOOGLE PLAY REVIEWS\r\n\r\nReviewPR\'s Custom Google Play Reviews are composed of Android application reviews by real users, very similar to their Quality Google Play Reviews content. These discussions are high quality.', 3.00, 5000, 'http://reviewpr.com/img/GooglePlayR.png', 'Positive Saas Reviews', 10, 'active', '2025-10-07 07:20:56', '2025-10-09 12:27:44'),
(24, 'Houzz Reviews', 'Buy Houzz Reviews', 'There is no doubt that reviews are very much important for the success of every business. To make sure you have an overall successful journey in the long run as well as to better leverage your online presence is to have some positive reviews from the clients that love you. You can buy positive Houzz Reviews cheap from ReviewPR. The customers can use any platform to add their opinion, across the different social media platforms, but the reviews on Houzz are a lot more important than the reviews on most platforms. As professionals, the positive reviews of customers just carry a lot of weight and are the most important things. Just remember, it\'s not the photos or a completed project, it\'s the good reviews that are most important to Houzz. Hence, it becomes relevant to buy Houzz Reviews here.', 4.00, 5000, 'http://reviewpr.com/img/HouzzR.png', 'Positive Saas Reviews', 29, 'active', '2025-10-07 07:24:54', '2025-10-09 12:32:49'),
(26, 'GoodFirms Reviews', 'Buy GoodFirms Reviews', 'Purchasing reviews has been a practice that has been done for a long time. Many companies, especially new ones that need to move faster, will find these purchases easier and more appealing than attempting to go through the organic processes. Today anyone can purchase quality GoodFirms reviews from reliable sources. You will want to avoid buying reviews from new sources or sources without enough positive reviews. Most of the spammy or fake reviews come from sources like these. \r\nreviewpr is one of the best trusted sources and a social media service where you can buy GoodFirms reviews from. Many people find reviewpr attractive because of their great support system that will resolve any issues quickly. They offer high quality organic reviews as well if you\'re concerned about getting banned. reviewpr also provides reviews for a fair rate compared to other sites. For instance, GoodFirms reviews are listed as $14.99.  They also have a good option to buy GoodFirms Reviews cheap and in quantity.', 19.99, 5000, 'http://reviewpr.com/img/GoodFirmsR.png', 'Positive Saas Reviews', 5, 'active', '2025-10-07 07:25:15', '2025-10-09 12:44:29'),
(28, 'Glassdoor Reviews', 'Buy Glassdoor Reviews for your Company - Real & Fast ', 'Numerous websites provide the possibility to buy cheap Glassdoor reviews. You will want to invest in these sites only after you do your due diligence to vet their services. You will want to check what productive services they are offering for your investment.', 6.99, 5000, 'http://reviewpr.com/img/GlassdoorR.png', 'Positive Saas Reviews', 17, 'active', '2025-10-07 07:29:25', '2025-10-09 12:45:43'),
(29, 'Wordpress Reviews', 'The Best Premium-Quality Wordpress Reviews\r\n', 'We assure that authentic and honest reviews will be provided by active users who have used our services. All reviews we receive will be based on actual user experiences, and they will be valid. All reviews supplied will be non-incentivized and so can contain both positive and negative reviews. Since they are unbeatable real reviews, you may get eight positives and two negatives, but there is no way to manipulate those actual real reviews. Accordingly, you will pay for the positive reviews only, and the negatives will be held for additional positive reviews. Our providers run advertisements across social media and encourage prospects, through sample reviews (via email widget), to write reviews of their experience with our products. ', 3.50, 5000, 'http://reviewpr.com/img/WordpressR.png', 'Positive Saas Reviews', 52, 'active', '2025-10-07 07:32:26', '2025-10-09 12:38:19'),
(30, 'BBB Reviews', 'Why Buy BBB Reviews', 'Acquiring BBB reviews can facilitate growth to your business\'s reputation ultimately leading to higher potential customer acquisition. BBB reviews can increase your popularity in a community that has an emphasis on the reviews of other consumers. In addition to a boost in popularity, when you acquire BBB reviews, you also increase your legitimacy and allow your company to ride back on the success of the platform\'s popularity and credibility.\r\n\r\nWhen you buy BBB reviews, there\'s nowhere to go but up for your business. Being a BBB Business gives users more access to finding out about:\r\n\r\n.When BBB users stumble upon your business, they will want to investigate further. Users will seek out your business as they will know exactly what products you have on offer, and positive reviews will encourage them in your direction, leading to more traffic for your site, and, ultimately more, traffic in the long run.\r\n.BBB reviews can also let other users find out about the service your business provides, and that is the same for you if you aren\'t selling products. This leads to more users wanting to check out your site, find out about your services, and will likely check them out, and along with them they will bring extra traffic to your site.\r\n.BBB reviews can lead other users to learn what you offer, and then similarly to not being a product seller. More users will be interested in looking up your site, determining what you have to offer, and trying it. In doing so, they will generate additional traffic for your site.\r\n.Increasing user traffic will want to verify the BBB reviews are legitimate. It means they\'re going to buy products and/or services from you to experience it for themselves. Additionally, you will have new users who will start reviewing your business and leaving feedback. \r\n.Eventually, more exposure combined with traffic from your s...[343 bytes truncated]', 6.00, 5000, 'http://reviewpr.com/img/BBBR.png', 'Positive Saas Reviews', 1, 'active', '2025-10-07 07:34:48', '2025-10-09 12:32:32'),
(31, 'Chrome Extension Reviews', 'A Top Assisted Purchase Chrome Extension Review', 'Get visibility with a quality, human written review done by a professional product reviewer. We will test or analyze your extension, note the important features, pros, and unique value, and write a thoughtful, SEO-optimized review that will drive users to you and convert sales.\r\nGreat for Chrome Web Store listings, your website, or marketing campaigns.', 4.99, 5000, 'http://reviewpr.com/img/ChromeR.png', 'Positive Saas Reviews', 13, 'active', '2025-10-07 07:38:07', '2025-10-09 12:45:29'),
(32, 'Amazon Reviews', 'Can You Purchase Exclusive Reviews?', 'ReviewPR has an array of choices when it comes to Amazon reviews. As the seller, it is your decision on which reviews to have to build your profile or your product rating. Sellers should beware and read specifics on the guidelines on how to ensure that purchased reviews are utilized for your account so your account does not get restricted or banned. These reviews do help services or products, but can always counteract the goal you are attempting to achieve with the reviews.\r\n', 10.00, 5000, 'http://reviewpr.com/img/AmazonR.png', 'Positive Saas Reviews', 41, 'active', '2025-10-07 07:40:46', '2025-10-09 12:35:03'),
(33, 'Producthunt Reviews', 'Buy Positive Product Hunt Reviews', 'If you\'re using Product Hunt to promote your business, positive reviews count. Products and services with a lot of positive reviews get noticed by the press. Good reviews are ways to develop a big audience. Some positive reviews that are too good to be true are sometimes generating skepticism from consumers.\r\n\r\nIt is important to find a reputable company to provide some good quality reviews from users. Consumers today can tell if a review is fake in a heartbeat. Usually, a few negative reviews provide reliability to positive reviews and are the reason some companies buy a few negative reviews as well. Having more examples of positive reviews will help you earn more sales.', 21.50, 5000, 'http://reviewpr.com/img/ProducthuntR.png', 'Positive Saas Reviews', 8, 'active', '2025-10-07 07:46:29', '2025-10-09 12:27:11'),
(34, 'Booking Reviews', 'Buy Cheap Booking Reviews ', 'At ReviewPR, you can purchase Booking reviews starting from $49.99. Most of our regular customers appreciate that our services justify the price tag and that we are not ridiculously priced, meaning we are cost-affordable and our quality of service matches the cost. We do not say we are providing the cheaper options, however, we always say we do not provide anything but legitimate options, so that our customers never have to deal with any potential trouble in the future.', 10.00, 5000, 'http://reviewpr.com/img/BookingR.png', 'Positive Saas Reviews', 25, 'active', '2025-10-07 07:47:27', '2025-10-09 12:32:05'),
(35, 'Reddit Posts / Comments', 'Authentic Reddit Comments & Posts – Genuine Engagement & Intelligent Promotion', 'A true, insightful Reddit post or comment for you that cultivates interest and credibility for your product/brand/idea. \r\nWe create posts that fit into the Reddit tone and community culture seamlessly - no spam, no bots - just great posts that can be used for:\r\n✅Product promotions\r\n✅SaaS/App discussions\r\n✅Community engagement\r\n✅Gain organic visibility & grow brand presence ', 4.00, 5000, 'http://reviewpr.com/img/Redit.R.png', 'Positive Saas Reviews', 15, 'active', '2025-10-07 07:48:58', '2025-10-09 12:28:39'),
(36, 'Etsy Reviews', 'Buy Safe Etsy Reviews', 'Every review we provide is secure and safe. We assure you, we do not receive your credential information, and all transactions will show up on your dashboard. We can guarantee that the product reviews are from real people who have used your product. This is our way of delivering high-quality and quality reviews to our partners.\r\n\r\nSome marketing agencies will claim that they are safe and trustworthy, but they only get reviews from bot traffic. This will result in poor conversions and untrustworthy feedback.', 4.50, 5000, 'http://reviewpr.com/img/EtsyR.png', 'Positive Saas Reviews', 45, 'active', '2025-10-07 07:50:22', '2025-10-09 12:36:11'),
(37, 'YouTube Comment Reviews', 'Buy quality YouTube reviews ', 'Enhance the credibility and interaction of your YouTube video by obtaining authentic, human-written comment reviews. \r\nWe generate natural conversational-style comments that promote your product, app, or service in a credible and organic manner with no bots or spam.', 1.30, 5000, 'http://reviewpr.com/img/YoutubeR.png', 'Positive Saas Reviews', 36, 'active', '2025-10-07 07:53:21', '2025-10-09 12:34:12'),
(38, 'TripAdvisor Positive Reviews', 'Increase TripAdvisor Positive Reviews ', 'Research suggests that over 70% of hotel bookings occur on the basis of positive online reviews, specifically those on TripAdvisor. So, your chances of being chosen as the hotel of choice more than triples if you buy TripAdvisor reviews from us. Whether consciously or unconsciously, the human mind is drawn towards that which others have approved. This is why we would like to show you how to increase TripAdvisor reviews for your business.\r\n', 3.99, 5000, 'http://reviewpr.com/img/TripadvisorR.png', 'Positive Saas Reviews', 24, 'active', '2025-10-07 07:54:49', '2025-10-09 12:46:17'),
(39, 'Instagram Reviews', 'Professional Instagram Reviews - Real, Engaging & Brand-Focused\r\n', 'Amp up your Instagram with real, human-written reviews that build trust and help you engage real people. \r\nWe write original Instagram captions, comments or mini-reviews in your brand\'s voice - no bots, no fake engagement.\r\n\r\n\r\nPerfect for: \r\n✅ Product / Service Promotions \r\n✅ Influencer & Brand Campaigns \r\n✅ Real Social Proof & Authenticity', 1.25, 5000, 'http://reviewpr.com/img/InstagramR.png', 'Positive Saas Reviews', 37, 'active', '2025-10-07 07:57:07', '2025-10-09 12:34:24'),
(40, 'Promotion On Forums', 'Forum Promotion – Genuine Posts & Organic Brand Awareness', 'Promote your product, service, or brand on highly-trafficked forums with genuine, engaging posts written by real people. \r\nWe develop natural, subject-relevant discussions or replies that establish credibility, and generate actual users — no spam or fake traffic.', 10.00, 5000, 'http://reviewpr.com/img/PromotionRN.png', 'Positive Saas Reviews', 55, 'active', '2025-10-07 07:59:53', '2025-10-09 12:38:57'),
(41, 'Shopify Reviews', 'Getting review or your Shopify store', 'Customers must understand that various people have purchased their product together with all customer feedback including both positive and negative evaluations. The following section presents multiple methods for obtaining reviews together with instructions to purchase affordable bulk Shopify reviews from ReviewPR.', 4.00, 5000, 'http://reviewpr.com/img/ShopifyR.png', 'Positive Saas Reviews', 43, 'active', '2025-10-07 08:00:02', '2025-10-09 12:35:42');

-- --------------------------------------------------------

--
-- Table structure for table `users`
--

CREATE TABLE `users` (
  `id` int NOT NULL,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `email` varchar(100) NOT NULL,
  `role` enum('admin','staff') NOT NULL DEFAULT 'staff',
  `last_login` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `users`
--

INSERT INTO `users` (`id`, `username`, `password`, `email`, `role`, `last_login`, `created_at`, `updated_at`) VALUES
(1, 'admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin@example.com', 'admin', NULL, '2025-10-14 10:43:04', '2025-10-14 10:43:04');

--
-- Indexes for dumped tables
--

--
-- Indexes for table `orders`
--
ALTER TABLE `orders`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `order_number` (`order_number`),
  ADD KEY `product_id` (`product_id`),
  ADD KEY `customer_email` (`customer_email`),
  ADD KEY `status` (`status`),
  ADD KEY `payment_status` (`payment_status`),
  ADD KEY `idx_orders_status_created` (`status`,`created_at`),
  ADD KEY `idx_orders_customer` (`customer_email`,`created_at`);

--
-- Indexes for table `order_status_history`
--
ALTER TABLE `order_status_history`
  ADD PRIMARY KEY (`id`),
  ADD KEY `order_id` (`order_id`),
  ADD KEY `changed_by` (`changed_by`);

--
-- Indexes for table `products`
--
ALTER TABLE `products`
  ADD PRIMARY KEY (`id`),
  ADD KEY `category` (`category`),
  ADD KEY `status` (`status`),
  ADD KEY `idx_products_category_status` (`category`,`status`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`),
  ADD UNIQUE KEY `username` (`username`),
  ADD UNIQUE KEY `email` (`email`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `orders`
--
ALTER TABLE `orders`
  MODIFY `id` int NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=5;

--
-- AUTO_INCREMENT for table `products`
--
-- --------------------------------------------------------
--
-- Table structure for table `categories`
--

CREATE TABLE `categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text,
  `position` int DEFAULT '1',
  `is_active` tinyint DEFAULT '1',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

--
-- Dumping data for table `categories`
--

INSERT INTO `categories` (`id`, `name`, `description`, `position`, `is_active`, `created_at`) VALUES
(1, 'Trustpilot', 'Trustpilot review services', 1, 1, '2025-10-19 04:47:00'),
(2, 'Google', 'Google review services', 2, 1, '2025-10-19 04:47:00'),
(3, 'G2', 'G2 review services', 3, 1, '2025-10-19 04:47:00'),
(4, 'Capterra', 'Capterra review services', 4, 1, '2025-10-19 04:47:00'),
(5, 'Yelp', 'Yelp review services', 5, 1, '2025-10-19 04:47:00'),
(6, 'Facebook', 'Facebook review services', 6, 1, '2025-10-19 04:47:00'),
(7, 'Other', 'Other review services', 7, 1, '2025-10-19 04:47:00');

-- --------------------------------------------------------

--
-- Constraints for dumped tables
--

--
-- Constraints for table `orders`
--
ALTER TABLE `orders`
  ADD CONSTRAINT `orders_product_fk` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE;

--
-- Constraints for table `order_status_history`
--
ALTER TABLE `order_status_history`
  ADD CONSTRAINT `order_history_order_fk` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE CASCADE,
  ADD CONSTRAINT `order_history_user_fk` FOREIGN KEY (`changed_by`) REFERENCES `users` (`id`) ON DELETE SET NULL;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
